{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

unit UnitReconeixementManualDeFonemes;

{************************************************}
INTERFACE
{************************************************}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, MMSystem, StdCtrls;

type
  TFormReconeixementManualDeFonemes = class(TForm)
    Panel: TPanel;
    SpeedButtonEngegarParar: TSpeedButton;
    SpeedButtonCaixaEines: TSpeedButton;
    SpeedButtonCopiarALaCarpeta: TSpeedButton;
    ComboBoxFonemes: TComboBox;
    LabelFonema: TLabel;
    CheckBoxGrandaria: TCheckBox;
    procedure SpeedButtonEngegarPararClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure SpeedButtonCaixaEinesClick(Sender: TObject);
    procedure SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
    procedure ComboBoxFonemesChange(Sender: TObject);
    procedure LabelFonemaMouseDown(Sender: TObject; Button: TMouseButton;Shift: TShiftState; X, Y: Integer);
    procedure LabelFonemaMouseUp(Sender: TObject; Button: TMouseButton;Shift: TShiftState; X, Y: Integer);
    procedure FormDeactivate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;Shift: TShiftState);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;Shift: TShiftState; X, Y: Integer);
    procedure FormKeyUp(Sender: TObject; var Key: Word;Shift: TShiftState);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
    procedure WMWIMDATA(var Msg: TMessage); message MM_WIM_DATA;
  public
    { Public declarations }
    Reconeixement:boolean;
  end;

var
  FormReconeixementManualDeFonemes: TFormReconeixementManualDeFonemes;

{************************************************}
IMPLEMENTATION
{************************************************}

Uses UnitEntradaSo, UnitCanviDeParametres, UnitTools;

{$R *.DFM}

procedure TFormReconeixementManualDeFonemes.FormCreate(Sender: TObject);
begin
  Randomize;
end;

procedure TFormReconeixementManualDeFonemes.FormClose(Sender: TObject;var Action: TCloseAction);
begin
  if not (SpeedButtonEngegarParar.Caption='E') then begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarParar.Down:=false;
  end;
end;

procedure TFormReconeixementManualDeFonemes.SpeedButtonEngegarPararClick(Sender: TObject);
begin
  if SpeedButtonEngegarParar.Caption='E' then begin
    SpeedButtonEngegarParar.Caption:='P';
    RePaint;
    //IniciarDadesUnitEntradaSo(512);
    IniciarDadesUnitEntradaSo(1024);
    ComboBoxFonemes.Enabled:=false;
    CheckBoxGrandaria.Enabled:=false;
    Reconeixement:=false;
    LabelFonema.Font.Size:=0;
    EngegarProcesEntradaSo(Handle);
  end else begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
    ComboBoxFonemes.Enabled:=true;
    CheckBoxGrandaria.Enabled:=true;
  end;
end;

procedure TFormReconeixementManualDeFonemes.WMWIMDATA(var Msg: TMessage);
var
  i,Max:integer;
begin
  Max:=0;
  For i:=1 to BytesBuffer do if so[NumeroBufer,i]-127>Max then Max:=so[NumeroBufer,i]-127;
  if (Max>ValorMinim) and (Max<=Valormaxim) then begin
    if CheckBoxGrandaria.Checked then LabelFonema.Font.Size:=300 else LabelFonema.Font.Size:=(Max-ValorMinim)*4;
    if Reconeixement then LabelFonema.Visible:=true;
    {
    if Reconeixement then begin
      if (Max-ValorMinim)*4>LabelFonema.Font.Size then LabelFonema.Font.Size:=(Max-ValorMinim)*4;
      LabelFonema.Visible:=true;
    end else begin
      LabelFonema.Font.Size:=0;
    end;
    }
  end else begin
    LabelFonema.Font.Size:=0;
    LabelFonema.Visible:=false;
  end;
  EntradaSo;
end;

procedure TFormReconeixementManualDeFonemes.SpeedButtonCaixaEinesClick(Sender: TObject);
begin
  FormCanviDeParametres.ShowModal;
end;

procedure TFormReconeixementManualDeFonemes.SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
var
  Rect:TRect;
begin
  Rect.Left:=0;
  Rect.Top:=Panel.Height;
  Rect.Right:=ClientRect.Right;
  Rect.Bottom:=ClientRect.Bottom;
  CopiarPartDeLaFinestraALaCarpeta(Handle,Rect);
end;

procedure TFormReconeixementManualDeFonemes.ComboBoxFonemesChange(Sender: TObject);
begin
 LabelFonema.Caption:=ComboBoxFonemes.Text;
end;

procedure TFormReconeixementManualDeFonemes.FormDeactivate(Sender: TObject);
begin
  Reconeixement:=false;
  LabelFonema.Visible:=false;
end;

procedure TFormReconeixementManualDeFonemes.LabelFonemaMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X,Y: Integer);
begin
  Reconeixement:=true;
end;

procedure TFormReconeixementManualDeFonemes.LabelFonemaMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X,Y: Integer);
begin
  Reconeixement:=false;
  LabelFonema.Visible:=false;
end;

procedure TFormReconeixementManualDeFonemes.FormKeyDown(Sender: TObject;var Key: Word; Shift: TShiftState);
begin
  Reconeixement:=true;
end;

procedure TFormReconeixementManualDeFonemes.FormKeyUp(Sender: TObject;var Key: Word; Shift: TShiftState);
begin
  Reconeixement:=false;
  LabelFonema.Visible:=false;
end;

procedure TFormReconeixementManualDeFonemes.FormMouseDown(Sender: TObject;Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button=mbleft then begin
    Reconeixement:=true;
  end else begin
    if not (SpeedButtonEngegarParar.Caption='E') then begin
      PararEntradaSo;
      FinalitzarEntradaSo;
      SpeedButtonEngegarParar.Caption:='E';
      SpeedButtonEngegarParar.Down:=false;
    end;
  end;
end;

procedure TFormReconeixementManualDeFonemes.FormMouseUp(Sender: TObject;Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  Reconeixement:=false;
  LabelFonema.Visible:=false;
end;

end.
